# Overview

This is a meritocratic, consensus-based community project. Anyone with an
interest in the project can join the community, contribute to the project design
and participate in the decision making process. This document describes how that
participation takes place and how to set about earning merit within the project
community.

# Roles And Responsibilities

## Users

Users are community members who have a need for the project. They are the most
important members of the community and without them the project would have no
purpose. Anyone can be a user; there are no special requirements.

The project asks its users to participate in the project and community as much
as possible. User contributions enable the project team to ensure that they are
satisfying the needs of those users. Common user contributions include (but are
not limited to):

* evangelising about the project (e.g. a link on a website and word-of-mouth awareness raising)
* informing developers of strengths and weaknesses from a new user perspective
* providing moral support (a ‘thank you’ goes a long way)
* providing financial support (the software is open source, but its developers need to eat)

Users who continue to engage with the project and its community will often
become more and more involved. Such users may find themselves becoming
contributors, as described in the next section.

## Contributors

Contributors are community members who contribute in concrete ways to the
project. Anyone can become a contributor, and contributions can take many forms,
as detailed in a separate document. There is no expectation of commitment to the
project, no specific skill requirements and no selection process.

In addition to their actions as users, contributors may also find themselves
doing one or more of the following:

* supporting new users (existing users are often the best people to support new users)
* reporting bugs
* identifying requirements
* providing graphics and web design
* programming
* assisting with project infrastructure
* writing documentation
* fixing bugs
* adding features

Contributors engage with the project through the issue tracker, or by writing or
editing documentation. They submit changes to the project itself via
pull-request, which will be considered for inclusion in the project by existing
maintainers (see next section).

As contributors gain experience and familiarity with the project, their profile
within, and commitment to, the community will increase. At some stage, they may
find themselves being nominated for maintainership.

## Maintainers

Maintainers are community members who have shown that they are committed to the
continued development of the project through ongoing engagement with the
community. Maintainership allows contributors to more easily carry on with their
project related activities by giving them direct access to the project’s
resources. That is, they *can* make changes directly to project outputs, without
having to submit changes via patches.

This does not mean that a maintainer is free to do what they want. In fact,
maintainers have no more authority over the project than contributors. While
maintainership indicates a valued member of the community who has demonstrated a
healthy respect for the project’s aims and objectives, their work continues to
be reviewed by the community before acceptance in an official release. The key
difference between a maintainer and a contributor is when this approval is
sought from the community. A maintainer seeks approval after the contribution is
made, rather than before.

Seeking approval after making a contribution is known as a commit-then-review
process. It is more efficient to allow trusted people to make direct
contributions, as the majority of those contributions will be accepted by the
project. The project employs various communication mechanisms to ensure that all
contributions are reviewed by the community as a whole. By the time a
contributor is invited to become a maintainer, they will have become familiar
with the project’s various tools as a user and then as a contributor.

Anyone can become a maintainer; there are no special requirements, other than to
have shown a willingness and ability to participate in the project as a team
player. Typically, a potential maintainer will need to show that they have an
understanding of the project, its objectives and its strategy. They will also
have provided valuable contributions to the project over a period of time.

New maintainers can be nominated by any existing maintainer. Once they have been
nominated, there will be a vote by the project management committee (PMC; see
below). Maintainer voting is one of the few activities that takes place on the
project’s private management list. This is to allow PMC members to freely
express their opinions about a nominee without causing embarrassment. Once the
vote has been held, the aggregated voting results are published on the public
wiki. The nominee is entitled to request an explanation of any ‘no’ votes
against them, regardless of the outcome of the vote. This explanation will be
provided by the PMC Chair (see below) and will be anonymous and constructive in
nature.

Nominees may decline their appointment as a maintainer. However, this is
unusual, as the project does not expect any specific time or resource commitment
from its community members. The intention behind the role of maintainer is to
allow people to contribute to the project more easily, not to tie them in to the
project in any formal way.

It is important to recognize that maintainership is a privilege, not a right.
That privilege must be earned and once earned it can be removed by the PMC (see
next section) in extreme circumstances. However, under normal circumstances
maintainership exists for as long as the maintainer wishes to continue engaging
with the project.

A maintainer who shows an above-average level of contribution to the project,
particularly with respect to its strategic direction and long-term health, may
be nominated to become a member of the PMC. This role is described below.

## Project management committee

The project management committee consists of those individuals identified as
"project admins" on the development site. The PMC has additional
responsibilities over and above those of a maintainer. These responsibilities
ensure the smooth running of the project. PMC members are expected to review
code contributions, participate in strategic planning, approve changes to the
governance model and manage the copyrights within the project outputs.

Members of the PMC do not have significant authority over other members of the
community, although it is the PMC that votes on new maintainers. It also makes
decisions when community consensus cannot be reached. In addition, the PMC has
access to the project’s private mailing list and its archives. This list is used
for sensitive issues, such as votes for new maintainers and legal matters that
cannot be discussed in public. It is never used for project management or
planning.

Membership of the PMC is by invitation from the existing PMC members. A
nomination will result in discussion and then a vote by the existing PMC
members. PMC membership votes are subject to consensus approval of the current
PMC members.

## PMC Chair

The PMC Chair is a single individual, voted for by the PMC members. Once someone
has been appointed Chair, they remain in that role until they choose to retire,
or the PMC casts a two-thirds majority vote to remove them.

The PMC Chair has no additional authority over other members of the PMC: the
role is one of coordinator and facilitator. The Chair is also expected to ensure
that all governance processes are adhered to, and has the casting vote when the
project fails to reach consensus.

# Support

All participants in the community are encouraged to provide support for new
users within the project management infrastructure. This support is provided as
a way of growing the community. Those seeking support should recognize that all
support activity within the project is voluntary and is therefore provided as
and when time allows. A user requiring guaranteed response times or results
should therefore seek to purchase a support contract from a community member.
However, for those willing to engage with the project on its own terms, and
willing to help support other users, the community support channels are ideal.

# Contribution Process

Anyone can contribute to the project, regardless of their skills, as there are
many ways to contribute. For instance, a contributor might be active on the
issue tracker, or might supply patches. The various ways of contributing are
described in more detail in a separate document.

A draft pull-request is the most appropriate place for a contributor to ask for
help when making their first contribution.

# Decision Making Process

Decisions about the future of the project are made through discussion with all
members of the community, from the newest user to the most experienced PMC
member. All non-sensitive project management discussion takes place on the
project issue tracker. Occasionally, sensitive discussion occurs on a private
channel.

In order to ensure that the project is not bogged down by endless discussion and
continual voting, the project operates a policy of lazy consensus. This allows
the majority of decisions to be made without resorting to a formal vote.

## Lazy consensus
Decision making typically involves the following steps:

1. Proposal
2. Discussion
3. Vote (if consensus is not reached through discussion)
4. Decision

Any community member can make a proposal for consideration by the community. In
order to initiate a discussion about a new idea, they should open an issue or
submit a draft pull-request implementing the idea to the main GitHub repository.
This will prompt a review and, if necessary, a discussion of the idea. The goal
of this review and discussion is to gain approval for the contribution. Since
most people in the project community have a shared vision, there is often little
need for discussion in order to reach consensus.

In general, as long as nobody explicitly opposes a proposal or patch, it is
recognized as having the support of the community. This is called lazy consensus
- that is, those who have not stated their opinion explicitly have implicitly
agreed to the implementation of the proposal.

Lazy consensus is a very important concept within the project. It is this
process that allows a large group of people to efficiently reach consensus, as
someone with no objections to a proposal need not spend time stating their
position, and others need not spend time reading such mails.

For lazy consensus to be effective, it is necessary to allow at least **72
hours** before assuming that there are no objections to the proposal. This
requirement ensures that everyone is given enough time to read, digest and
respond to the proposal. This time period is chosen so as to be as inclusive as
possible of all participants, regardless of their location and time commitments.

## Voting

Not all decisions can be made using lazy consensus. Issues such as those
affecting the strategic direction or legal standing of the project must gain
explicit approval in the form of a vote. Every member of the community is
encouraged to express their opinions in all discussion and all votes. However,
only project maintainers and/or PMC members (as defined above) have binding
votes for the purposes of decision making. A separate document on the voting
within a meritocratic governance model describes in more detail how voting is
conducted in projects following [the practice established within the Apache
Software Foundation](https://www.apache.org/foundation/voting.html).

# Credits

This govenance document was based on a
[template](http://oss-watch.ac.uk/resources/meritocraticgovernancemodel) which
was based on the the [Apache Software Foundation's governance
model](http://www.apache.org/foundation/how-it-works.html#meritocracy).
