[comment {-*- tcl -*- doctools manpage}]
[include pkg_version.inc]
[manpage_begin critcl-cproc-types n [vset VERSION]]
[include include/module.inc]
[titledesc {Critcl - cproc Type Reference}]
[require Tcl 8.4]
[require critcl [opt [vset VERSION]]]
[description]
[para]
[include include/welcome.inc]
[para]

This document is a breakout of the descriptions for the predefined
argument- and result-types usable with the [cmd critcl::cproc]
command, as detailed in the reference manpage for the [package critcl]
package, plus the information on how to extend the predefined set with
custom types. The breakout was made to make this information easier to
find (toplevel document vs. having to search the large main reference).

[para] Its intended audience are developers wishing to write Tcl
packages with embedded C code.

[section {Standard argument types}]	[include include/api_stdat_cproc.inc]
[section {Standard result types}]	[include include/api_stdrt_cproc.inc]
[section {Advanced: Adding types}]	[include include/api_extcproc2.inc]

[section Examples]

The examples shown here have been drawn from section "Embedding C" in
the document about [manpage {Using CriTcl}]. Please see that document
for many more examples.

[include include/using_eproc.inc]        [comment {%% cproc}]
[include include/using_eproctypes.inc]   [comment {%% cproc types, intro & trivial}]
[include include/using_eproctypes2.inc]  [comment {%% cproc types, semi-trivial}]
[include include/using_eproctypes3.inc]  [comment {%% cproc types, support (incl alloc'd)}]
[include include/using_eproctypes4.inc]  [comment {%% cproc types, results}]

[comment {===================================================================}]
[include include/feedback.inc]
[manpage_end]
