/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at https://curl.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 * SPDX-License-Identifier: curl
 *
 ***************************************************************************/
/* <DESC>
 * using the multi interface to do a multipart formpost without blocking
 * </DESC>
 */
/*
 * Warning: this example uses the deprecated form API. See "multi-post.c"
 *          for a similar example using the mime API.
 */
#include <stdio.h>
#include <string.h>

#include <curl/curl.h>

int main(void)
{
  CURL *curl;

  struct curl_httppost *formpost = NULL;
  struct curl_httppost *lastptr = NULL;
  struct curl_slist *headerlist = NULL;
  static const char buf[] = "Expect:";

  CURLcode res = curl_global_init(CURL_GLOBAL_ALL);
  if(res)
    return (int)res;

  CURL_IGNORE_DEPRECATION(
    /* Fill in the file upload field. This makes libcurl load data from
       the given filename when curl_easy_perform() is called. */
    curl_formadd(&formpost,
                 &lastptr,
                 CURLFORM_COPYNAME, "sendfile",
                 CURLFORM_FILE, "multi-formadd.c",
                 CURLFORM_END);

    /* Fill in the filename field */
    curl_formadd(&formpost,
                 &lastptr,
                 CURLFORM_COPYNAME, "filename",
                 CURLFORM_COPYCONTENTS, "multi-formadd.c",
                 CURLFORM_END);

    /* Fill in the submit field too, even if this is rarely needed */
    curl_formadd(&formpost,
                 &lastptr,
                 CURLFORM_COPYNAME, "submit",
                 CURLFORM_COPYCONTENTS, "send",
                 CURLFORM_END);
  )

  /* initialize custom header list (stating that Expect: 100-continue is not
     wanted */
  headerlist = curl_slist_append(headerlist, buf);

  curl = curl_easy_init();
  if(curl) {
    CURLM *multi;

    multi = curl_multi_init();
    if(multi) {

      int still_running = 0;

      /* what URL that receives this POST */
      curl_easy_setopt(curl, CURLOPT_URL,
                       "https://www.example.com/upload.cgi");
      curl_easy_setopt(curl, CURLOPT_VERBOSE, 1L);

      curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headerlist);
      CURL_IGNORE_DEPRECATION(
        curl_easy_setopt(curl, CURLOPT_HTTPPOST, formpost);
      )

      curl_multi_add_handle(multi, curl);

      do {
        CURLMcode mc = curl_multi_perform(multi, &still_running);

        if(still_running)
          /* wait for activity, timeout or "nothing" */
          mc = curl_multi_poll(multi, NULL, 0, 1000, NULL);

        if(mc)
          break;

      } while(still_running);

      curl_multi_cleanup(multi);
    }

    /* always cleanup */
    curl_easy_cleanup(curl);
  }

  CURL_IGNORE_DEPRECATION(
    /* then cleanup the formpost chain */
    curl_formfree(formpost);
  )

  /* free slist */
  curl_slist_free_all(headerlist);

  curl_global_cleanup();

  return 0;
}
