//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/search/armsearch"
	"net/http"
	"net/url"
	"regexp"
)

// AdminKeysServer is a fake server for instances of the armsearch.AdminKeysClient type.
type AdminKeysServer struct {
	// Get is the fake for method AdminKeysClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, searchServiceName string, searchManagementRequestOptions *armsearch.SearchManagementRequestOptions, options *armsearch.AdminKeysClientGetOptions) (resp azfake.Responder[armsearch.AdminKeysClientGetResponse], errResp azfake.ErrorResponder)

	// Regenerate is the fake for method AdminKeysClient.Regenerate
	// HTTP status codes to indicate success: http.StatusOK
	Regenerate func(ctx context.Context, resourceGroupName string, searchServiceName string, keyKind armsearch.AdminKeyKind, searchManagementRequestOptions *armsearch.SearchManagementRequestOptions, options *armsearch.AdminKeysClientRegenerateOptions) (resp azfake.Responder[armsearch.AdminKeysClientRegenerateResponse], errResp azfake.ErrorResponder)
}

// NewAdminKeysServerTransport creates a new instance of AdminKeysServerTransport with the provided implementation.
// The returned AdminKeysServerTransport instance is connected to an instance of armsearch.AdminKeysClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAdminKeysServerTransport(srv *AdminKeysServer) *AdminKeysServerTransport {
	return &AdminKeysServerTransport{srv: srv}
}

// AdminKeysServerTransport connects instances of armsearch.AdminKeysClient to instances of AdminKeysServer.
// Don't use this type directly, use NewAdminKeysServerTransport instead.
type AdminKeysServerTransport struct {
	srv *AdminKeysServer
}

// Do implements the policy.Transporter interface for AdminKeysServerTransport.
func (a *AdminKeysServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AdminKeysClient.Get":
		resp, err = a.dispatchGet(req)
	case "AdminKeysClient.Regenerate":
		resp, err = a.dispatchRegenerate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AdminKeysServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Search/searchServices/(?P<searchServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAdminKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	searchServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("searchServiceName")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "x-ms-client-request-id"))
	var searchManagementRequestOptions *armsearch.SearchManagementRequestOptions
	if clientRequestIDParam != nil {
		searchManagementRequestOptions = &armsearch.SearchManagementRequestOptions{
			ClientRequestID: clientRequestIDParam,
		}
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, searchServiceNameParam, searchManagementRequestOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdminKeyResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AdminKeysServerTransport) dispatchRegenerate(req *http.Request) (*http.Response, error) {
	if a.srv.Regenerate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Regenerate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Search/searchServices/(?P<searchServiceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateAdminKey/(?P<keyKind>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	searchServiceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("searchServiceName")])
	if err != nil {
		return nil, err
	}
	keyKindParam, err := parseWithCast(matches[regex.SubexpIndex("keyKind")], func(v string) (armsearch.AdminKeyKind, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsearch.AdminKeyKind(p), nil
	})
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "x-ms-client-request-id"))
	var searchManagementRequestOptions *armsearch.SearchManagementRequestOptions
	if clientRequestIDParam != nil {
		searchManagementRequestOptions = &armsearch.SearchManagementRequestOptions{
			ClientRequestID: clientRequestIDParam,
		}
	}
	respr, errRespr := a.srv.Regenerate(req.Context(), resourceGroupNameParam, searchServiceNameParam, keyKindParam, searchManagementRequestOptions, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdminKeyResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
