// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/visionai/v1/lva.proto

package visionaipb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// RunMode represents the mode to launch the Process on.
type RunMode int32

const (
	// Mode is unspecified.
	RunMode_RUN_MODE_UNSPECIFIED RunMode = 0
	// Live mode. Meaning the Process is launched to handle live video
	// source, and possible packet drops are expected.
	RunMode_LIVE RunMode = 1
	// Submission mode. Meaning the Process is launched to handle bounded video
	// files, with no packet drop. Completion status is tracked.
	RunMode_SUBMISSION RunMode = 2
)

// Enum value maps for RunMode.
var (
	RunMode_name = map[int32]string{
		0: "RUN_MODE_UNSPECIFIED",
		1: "LIVE",
		2: "SUBMISSION",
	}
	RunMode_value = map[string]int32{
		"RUN_MODE_UNSPECIFIED": 0,
		"LIVE":                 1,
		"SUBMISSION":           2,
	}
)

func (x RunMode) Enum() *RunMode {
	p := new(RunMode)
	*p = x
	return p
}

func (x RunMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RunMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_lva_proto_enumTypes[0].Descriptor()
}

func (RunMode) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_lva_proto_enumTypes[0]
}

func (x RunMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RunMode.Descriptor instead.
func (RunMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{0}
}

// State represents the running status of the Process.
type RunStatus_State int32

const (
	// State is unspecified.
	RunStatus_STATE_UNSPECIFIED RunStatus_State = 0
	// INITIALIZING means the Process is scheduled but yet ready to handle
	// real traffic.
	RunStatus_INITIALIZING RunStatus_State = 1
	// RUNNING means the Process is up running and handling traffic.
	RunStatus_RUNNING RunStatus_State = 2
	// COMPLETED means the Process has completed the processing, especially
	// for non-streaming use case.
	RunStatus_COMPLETED RunStatus_State = 3
	// FAILED means the Process failed to complete the processing.
	RunStatus_FAILED RunStatus_State = 4
	// PENDING means the Process is created but yet to be scheduled.
	RunStatus_PENDING RunStatus_State = 5
)

// Enum value maps for RunStatus_State.
var (
	RunStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INITIALIZING",
		2: "RUNNING",
		3: "COMPLETED",
		4: "FAILED",
		5: "PENDING",
	}
	RunStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"INITIALIZING":      1,
		"RUNNING":           2,
		"COMPLETED":         3,
		"FAILED":            4,
		"PENDING":           5,
	}
)

func (x RunStatus_State) Enum() *RunStatus_State {
	p := new(RunStatus_State)
	*p = x
	return p
}

func (x RunStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RunStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_lva_proto_enumTypes[1].Descriptor()
}

func (RunStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_lva_proto_enumTypes[1]
}

func (x RunStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RunStatus_State.Descriptor instead.
func (RunStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{5, 0}
}

// Defines the interface of an Operator.
//
// Arguments to an operator are input/output streams that are getting
// processesed/returned while attributes are fixed configuration parameters.
type OperatorDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this operator.
	//
	// Tentatively [A-Z][a-zA-Z0-9]*, e.g., BboxCounter, PetDetector,
	// PetDetector1.
	Operator string `protobuf:"bytes,1,opt,name=operator,proto3" json:"operator,omitempty"`
	// Declares input arguments.
	InputArgs []*OperatorDefinition_ArgumentDefinition `protobuf:"bytes,2,rep,name=input_args,json=inputArgs,proto3" json:"input_args,omitempty"`
	// Declares output arguments.
	OutputArgs []*OperatorDefinition_ArgumentDefinition `protobuf:"bytes,3,rep,name=output_args,json=outputArgs,proto3" json:"output_args,omitempty"`
	// Declares the attributes.
	Attributes []*OperatorDefinition_AttributeDefinition `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// The resources for running the operator.
	Resources *ResourceSpecification `protobuf:"bytes,5,opt,name=resources,proto3" json:"resources,omitempty"`
	// Short description of the operator.
	ShortDescription string `protobuf:"bytes,6,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// Full description of the operator.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *OperatorDefinition) Reset() {
	*x = OperatorDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperatorDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperatorDefinition) ProtoMessage() {}

func (x *OperatorDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperatorDefinition.ProtoReflect.Descriptor instead.
func (*OperatorDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{0}
}

func (x *OperatorDefinition) GetOperator() string {
	if x != nil {
		return x.Operator
	}
	return ""
}

func (x *OperatorDefinition) GetInputArgs() []*OperatorDefinition_ArgumentDefinition {
	if x != nil {
		return x.InputArgs
	}
	return nil
}

func (x *OperatorDefinition) GetOutputArgs() []*OperatorDefinition_ArgumentDefinition {
	if x != nil {
		return x.OutputArgs
	}
	return nil
}

func (x *OperatorDefinition) GetAttributes() []*OperatorDefinition_AttributeDefinition {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *OperatorDefinition) GetResources() *ResourceSpecification {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *OperatorDefinition) GetShortDescription() string {
	if x != nil {
		return x.ShortDescription
	}
	return ""
}

func (x *OperatorDefinition) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// ResourceSpec collects a set of resources that can
// be used to specify requests and requirements.
//
// Note: Highly experimental as this can be runtime dependent.
// Can use the "extras" field to experiment first before trying
// to abstract it.
type ResourceSpecification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CPU specification.
	//
	// Examples:
	// "100m", "0.5", "1", "2", ... correspond to
	// 0.1, half, 1, or 2 cpus.
	//
	// Leave empty to let the system decide.
	//
	// Note that this does *not* determine the cpu vender/make,
	// or its underlying clock speed and specific SIMD features.
	// It is only the amount time it requires in timeslicing.
	Cpu string `protobuf:"bytes,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// CPU limit.
	//
	// Examples:
	// "100m", "0.5", "1", "2", ... correspond to
	// 0.1, half, 1, or 2 cpus.
	//
	// Leave empty to indicate no limit.
	CpuLimits string `protobuf:"bytes,5,opt,name=cpu_limits,json=cpuLimits,proto3" json:"cpu_limits,omitempty"`
	// Memory specification (in bytes).
	//
	// Examples:
	// "128974848", "129e6", "129M", "123Mi", ... correspond to
	// 128974848 bytes, 129000000 bytes, 129 mebibytes, 123 megabytes.
	//
	// Leave empty to let the system decide.
	Memory string `protobuf:"bytes,2,opt,name=memory,proto3" json:"memory,omitempty"`
	// Memory usage limits.
	//
	// Examples:
	// "128974848", "129e6", "129M", "123Mi", ... correspond to
	// 128974848 bytes, 129000000 bytes, 129 mebibytes, 123 megabytes.
	//
	// Leave empty to indicate no limit.
	MemoryLimits string `protobuf:"bytes,6,opt,name=memory_limits,json=memoryLimits,proto3" json:"memory_limits,omitempty"`
	// Number of gpus.
	Gpus int32 `protobuf:"varint,3,opt,name=gpus,proto3" json:"gpus,omitempty"`
	// The maximum latency that this operator may use to process an element.
	//
	// If non positive, then a system default will be used.
	// Operator developers should arrange for the system compute resources to be
	// aligned with this latency budget; e.g. if you want a ML model to produce
	// results within 500ms, then you should make sure you request enough
	// cpu/gpu/memory to achieve that.
	LatencyBudgetMs int32 `protobuf:"varint,4,opt,name=latency_budget_ms,json=latencyBudgetMs,proto3" json:"latency_budget_ms,omitempty"`
}

func (x *ResourceSpecification) Reset() {
	*x = ResourceSpecification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceSpecification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceSpecification) ProtoMessage() {}

func (x *ResourceSpecification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceSpecification.ProtoReflect.Descriptor instead.
func (*ResourceSpecification) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{1}
}

func (x *ResourceSpecification) GetCpu() string {
	if x != nil {
		return x.Cpu
	}
	return ""
}

func (x *ResourceSpecification) GetCpuLimits() string {
	if x != nil {
		return x.CpuLimits
	}
	return ""
}

func (x *ResourceSpecification) GetMemory() string {
	if x != nil {
		return x.Memory
	}
	return ""
}

func (x *ResourceSpecification) GetMemoryLimits() string {
	if x != nil {
		return x.MemoryLimits
	}
	return ""
}

func (x *ResourceSpecification) GetGpus() int32 {
	if x != nil {
		return x.Gpus
	}
	return 0
}

func (x *ResourceSpecification) GetLatencyBudgetMs() int32 {
	if x != nil {
		return x.LatencyBudgetMs
	}
	return 0
}

// Represents an actual value of an operator attribute.
type AttributeValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Attribute value.
	//
	// Types that are assignable to Value:
	//
	//	*AttributeValue_I
	//	*AttributeValue_F
	//	*AttributeValue_B
	//	*AttributeValue_S
	Value isAttributeValue_Value `protobuf_oneof:"value"`
}

func (x *AttributeValue) Reset() {
	*x = AttributeValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeValue) ProtoMessage() {}

func (x *AttributeValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeValue.ProtoReflect.Descriptor instead.
func (*AttributeValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{2}
}

func (m *AttributeValue) GetValue() isAttributeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *AttributeValue) GetI() int64 {
	if x, ok := x.GetValue().(*AttributeValue_I); ok {
		return x.I
	}
	return 0
}

func (x *AttributeValue) GetF() float32 {
	if x, ok := x.GetValue().(*AttributeValue_F); ok {
		return x.F
	}
	return 0
}

func (x *AttributeValue) GetB() bool {
	if x, ok := x.GetValue().(*AttributeValue_B); ok {
		return x.B
	}
	return false
}

func (x *AttributeValue) GetS() []byte {
	if x, ok := x.GetValue().(*AttributeValue_S); ok {
		return x.S
	}
	return nil
}

type isAttributeValue_Value interface {
	isAttributeValue_Value()
}

type AttributeValue_I struct {
	// int.
	I int64 `protobuf:"varint,1,opt,name=i,proto3,oneof"`
}

type AttributeValue_F struct {
	// float.
	F float32 `protobuf:"fixed32,2,opt,name=f,proto3,oneof"`
}

type AttributeValue_B struct {
	// bool.
	B bool `protobuf:"varint,3,opt,name=b,proto3,oneof"`
}

type AttributeValue_S struct {
	// string.
	S []byte `protobuf:"bytes,4,opt,name=s,proto3,oneof"`
}

func (*AttributeValue_I) isAttributeValue_Value() {}

func (*AttributeValue_F) isAttributeValue_Value() {}

func (*AttributeValue_B) isAttributeValue_Value() {}

func (*AttributeValue_S) isAttributeValue_Value() {}

// Defines an Analyzer.
//
// An analyzer processes data from its input streams using the logic defined in
// the Operator that it represents. Of course, it produces data for the output
// streams declared in the Operator.
type AnalyzerDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this analyzer.
	//
	// Tentatively [a-z][a-z0-9]*(_[a-z0-9]+)*.
	Analyzer string `protobuf:"bytes,1,opt,name=analyzer,proto3" json:"analyzer,omitempty"`
	// The name of the operator that this analyzer runs.
	//
	// Must match the name of a supported operator.
	Operator string `protobuf:"bytes,2,opt,name=operator,proto3" json:"operator,omitempty"`
	// Input streams.
	Inputs []*AnalyzerDefinition_StreamInput `protobuf:"bytes,3,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// The attribute values that this analyzer applies to the operator.
	//
	// Supply a mapping between the attribute names and the actual value you wish
	// to apply. If an attribute name is omitted, then it will take a
	// preconfigured default value.
	Attrs map[string]*AttributeValue `protobuf:"bytes,4,rep,name=attrs,proto3" json:"attrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Debug options.
	DebugOptions *AnalyzerDefinition_DebugOptions `protobuf:"bytes,5,opt,name=debug_options,json=debugOptions,proto3" json:"debug_options,omitempty"`
	// Operator option.
	OperatorOption *AnalyzerDefinition_OperatorOption `protobuf:"bytes,6,opt,name=operator_option,json=operatorOption,proto3" json:"operator_option,omitempty"`
}

func (x *AnalyzerDefinition) Reset() {
	*x = AnalyzerDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerDefinition) ProtoMessage() {}

func (x *AnalyzerDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerDefinition.ProtoReflect.Descriptor instead.
func (*AnalyzerDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{3}
}

func (x *AnalyzerDefinition) GetAnalyzer() string {
	if x != nil {
		return x.Analyzer
	}
	return ""
}

func (x *AnalyzerDefinition) GetOperator() string {
	if x != nil {
		return x.Operator
	}
	return ""
}

func (x *AnalyzerDefinition) GetInputs() []*AnalyzerDefinition_StreamInput {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *AnalyzerDefinition) GetAttrs() map[string]*AttributeValue {
	if x != nil {
		return x.Attrs
	}
	return nil
}

func (x *AnalyzerDefinition) GetDebugOptions() *AnalyzerDefinition_DebugOptions {
	if x != nil {
		return x.DebugOptions
	}
	return nil
}

func (x *AnalyzerDefinition) GetOperatorOption() *AnalyzerDefinition_OperatorOption {
	if x != nil {
		return x.OperatorOption
	}
	return nil
}

// Defines a full analysis.
//
// This is a description of the overall live analytics pipeline.
// You may think of this as an edge list representation of a multigraph.
//
// This may be directly authored by a human in protobuf textformat, or it may be
// generated by a programming API (perhaps Python or JavaScript depending on
// context).
type AnalysisDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Analyzer definitions.
	Analyzers []*AnalyzerDefinition `protobuf:"bytes,1,rep,name=analyzers,proto3" json:"analyzers,omitempty"`
}

func (x *AnalysisDefinition) Reset() {
	*x = AnalysisDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalysisDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalysisDefinition) ProtoMessage() {}

func (x *AnalysisDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalysisDefinition.ProtoReflect.Descriptor instead.
func (*AnalysisDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{4}
}

func (x *AnalysisDefinition) GetAnalyzers() []*AnalyzerDefinition {
	if x != nil {
		return x.Analyzers
	}
	return nil
}

// Message describing the status of the Process.
type RunStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the Process.
	State RunStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.visionai.v1.RunStatus_State" json:"state,omitempty"`
	// The reason of becoming the state.
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *RunStatus) Reset() {
	*x = RunStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunStatus) ProtoMessage() {}

func (x *RunStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunStatus.ProtoReflect.Descriptor instead.
func (*RunStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{5}
}

func (x *RunStatus) GetState() RunStatus_State {
	if x != nil {
		return x.State
	}
	return RunStatus_STATE_UNSPECIFIED
}

func (x *RunStatus) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

// Defines an argument to an operator.
//
// Used for both inputs and outputs.
type OperatorDefinition_ArgumentDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the argument.
	//
	// Tentatively [a-z]([_a-z0-9]*[a-z0-9])?, e.g., video, audio,
	// high_fps_frame.
	Argument string `protobuf:"bytes,1,opt,name=argument,proto3" json:"argument,omitempty"`
	// The data type of the argument.
	//
	// This should match the textual representation of a stream/Packet type.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *OperatorDefinition_ArgumentDefinition) Reset() {
	*x = OperatorDefinition_ArgumentDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperatorDefinition_ArgumentDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperatorDefinition_ArgumentDefinition) ProtoMessage() {}

func (x *OperatorDefinition_ArgumentDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperatorDefinition_ArgumentDefinition.ProtoReflect.Descriptor instead.
func (*OperatorDefinition_ArgumentDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{0, 0}
}

func (x *OperatorDefinition_ArgumentDefinition) GetArgument() string {
	if x != nil {
		return x.Argument
	}
	return ""
}

func (x *OperatorDefinition_ArgumentDefinition) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Defines an attribute of an operator.
type OperatorDefinition_AttributeDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the attribute.
	//
	// Tentatively [a-z]([_a-z0-9]*[a-z0-9])?, e.g., max_frames_per_video,
	// resize_height.
	Attribute string `protobuf:"bytes,1,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// The type of this attribute.
	//
	// See attribute_value.proto for possibilities.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The default value for the attribute.
	DefaultValue *AttributeValue `protobuf:"bytes,3,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
}

func (x *OperatorDefinition_AttributeDefinition) Reset() {
	*x = OperatorDefinition_AttributeDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperatorDefinition_AttributeDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperatorDefinition_AttributeDefinition) ProtoMessage() {}

func (x *OperatorDefinition_AttributeDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperatorDefinition_AttributeDefinition.ProtoReflect.Descriptor instead.
func (*OperatorDefinition_AttributeDefinition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{0, 1}
}

func (x *OperatorDefinition_AttributeDefinition) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

func (x *OperatorDefinition_AttributeDefinition) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *OperatorDefinition_AttributeDefinition) GetDefaultValue() *AttributeValue {
	if x != nil {
		return x.DefaultValue
	}
	return nil
}

// The inputs to this analyzer.
//
// We accept input name references of the following form:
// <analyzer-name>:<output-argument-name>
//
// Example:
//
// Suppose you had an operator named "SomeOp" that has 2 output
// arguments, the first of which is named "foo" and the second of which is
// named "bar", and an operator named "MyOp" that accepts 2 inputs.
//
// Also suppose that there is an analyzer named "some-analyzer" that is
// running "SomeOp" and another analyzer named "my-analyzer" running "MyOp".
//
// To indicate that "my-analyzer" is to consume "some-analyzer"'s "foo"
// output as its first input and "some-analyzer"'s "bar" output as its
// second input, you can set this field to the following:
// input = ["some-analyzer:foo", "some-analyzer:bar"]
type AnalyzerDefinition_StreamInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the stream input (as discussed above).
	Input string `protobuf:"bytes,1,opt,name=input,proto3" json:"input,omitempty"`
}

func (x *AnalyzerDefinition_StreamInput) Reset() {
	*x = AnalyzerDefinition_StreamInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerDefinition_StreamInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerDefinition_StreamInput) ProtoMessage() {}

func (x *AnalyzerDefinition_StreamInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerDefinition_StreamInput.ProtoReflect.Descriptor instead.
func (*AnalyzerDefinition_StreamInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{3, 0}
}

func (x *AnalyzerDefinition_StreamInput) GetInput() string {
	if x != nil {
		return x.Input
	}
	return ""
}

// Options available for debugging purposes only.
type AnalyzerDefinition_DebugOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Environment variables.
	EnvironmentVariables map[string]string `protobuf:"bytes,1,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AnalyzerDefinition_DebugOptions) Reset() {
	*x = AnalyzerDefinition_DebugOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerDefinition_DebugOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerDefinition_DebugOptions) ProtoMessage() {}

func (x *AnalyzerDefinition_DebugOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerDefinition_DebugOptions.ProtoReflect.Descriptor instead.
func (*AnalyzerDefinition_DebugOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{3, 1}
}

func (x *AnalyzerDefinition_DebugOptions) GetEnvironmentVariables() map[string]string {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

// Option related to the operator.
type AnalyzerDefinition_OperatorOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tag of the operator.
	Tag string `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// Registry of the operator. e.g. public, dev.
	Registry string `protobuf:"bytes,2,opt,name=registry,proto3" json:"registry,omitempty"`
}

func (x *AnalyzerDefinition_OperatorOption) Reset() {
	*x = AnalyzerDefinition_OperatorOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerDefinition_OperatorOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerDefinition_OperatorOption) ProtoMessage() {}

func (x *AnalyzerDefinition_OperatorOption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerDefinition_OperatorOption.ProtoReflect.Descriptor instead.
func (*AnalyzerDefinition_OperatorOption) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_proto_rawDescGZIP(), []int{3, 2}
}

func (x *AnalyzerDefinition_OperatorOption) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

func (x *AnalyzerDefinition_OperatorOption) GetRegistry() string {
	if x != nil {
		return x.Registry
	}
	return ""
}

var File_google_cloud_visionai_v1_lva_proto protoreflect.FileDescriptor

var file_google_cloud_visionai_v1_lva_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x76, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x22, 0xd1,
	0x05, 0x0a, 0x12, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x12, 0x5e, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x72, 0x67, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x72, 0x67,
	0x73, 0x12, 0x60, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x72, 0x67, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41,
	0x72, 0x67, 0x73, 0x12, 0x60, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x44, 0x0a, 0x12, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x72, 0x67,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x96, 0x01, 0x0a, 0x13, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0xc5, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03,
	0x63, 0x70, 0x75, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x63, 0x70, 0x75, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x70, 0x75, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x70, 0x75, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x16, 0x0a,
	0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x70,
	0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x67, 0x70, 0x75, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x5f, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x6c, 0x61, 0x74, 0x65, 0x6e,
	0x63, 0x79, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x73, 0x22, 0x59, 0x0a, 0x0e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x0e, 0x0a, 0x01,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x01, 0x69, 0x12, 0x0e, 0x0a, 0x01,
	0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x01, 0x66, 0x12, 0x0e, 0x0a, 0x01,
	0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x01, 0x62, 0x12, 0x0e, 0x0a, 0x01,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x01, 0x73, 0x42, 0x07, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xe1, 0x06, 0x0a, 0x12, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x12, 0x50, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x06,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x05, 0x61, 0x74, 0x74, 0x72, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05,
	0x61, 0x74, 0x74, 0x72, 0x73, 0x12, 0x5e, 0x0a, 0x0d, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x64, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x23, 0x0a, 0x0b, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x1a, 0xe2, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x88, 0x01, 0x0a, 0x15, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x14, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x1a, 0x47, 0x0a, 0x19,
	0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x1a, 0x62, 0x0a, 0x0a, 0x41, 0x74, 0x74, 0x72, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x60, 0x0a, 0x12, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4a, 0x0a, 0x09, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x73, 0x22, 0xcb, 0x01, 0x0a, 0x09,
	0x52, 0x75, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3f, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x2a, 0x3d, 0x0a, 0x07, 0x52, 0x75, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x55, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08,
	0x0a, 0x04, 0x4c, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x42, 0x4d,
	0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x42, 0xb8, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x42, 0x08, 0x4c, 0x76, 0x61, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x70, 0x62, 0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x70, 0x62, 0xaa,
	0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x49, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visionai_v1_lva_proto_rawDescOnce sync.Once
	file_google_cloud_visionai_v1_lva_proto_rawDescData = file_google_cloud_visionai_v1_lva_proto_rawDesc
)

func file_google_cloud_visionai_v1_lva_proto_rawDescGZIP() []byte {
	file_google_cloud_visionai_v1_lva_proto_rawDescOnce.Do(func() {
		file_google_cloud_visionai_v1_lva_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visionai_v1_lva_proto_rawDescData)
	})
	return file_google_cloud_visionai_v1_lva_proto_rawDescData
}

var file_google_cloud_visionai_v1_lva_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_visionai_v1_lva_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_visionai_v1_lva_proto_goTypes = []interface{}{
	(RunMode)(0),                                   // 0: google.cloud.visionai.v1.RunMode
	(RunStatus_State)(0),                           // 1: google.cloud.visionai.v1.RunStatus.State
	(*OperatorDefinition)(nil),                     // 2: google.cloud.visionai.v1.OperatorDefinition
	(*ResourceSpecification)(nil),                  // 3: google.cloud.visionai.v1.ResourceSpecification
	(*AttributeValue)(nil),                         // 4: google.cloud.visionai.v1.AttributeValue
	(*AnalyzerDefinition)(nil),                     // 5: google.cloud.visionai.v1.AnalyzerDefinition
	(*AnalysisDefinition)(nil),                     // 6: google.cloud.visionai.v1.AnalysisDefinition
	(*RunStatus)(nil),                              // 7: google.cloud.visionai.v1.RunStatus
	(*OperatorDefinition_ArgumentDefinition)(nil),  // 8: google.cloud.visionai.v1.OperatorDefinition.ArgumentDefinition
	(*OperatorDefinition_AttributeDefinition)(nil), // 9: google.cloud.visionai.v1.OperatorDefinition.AttributeDefinition
	(*AnalyzerDefinition_StreamInput)(nil),         // 10: google.cloud.visionai.v1.AnalyzerDefinition.StreamInput
	(*AnalyzerDefinition_DebugOptions)(nil),        // 11: google.cloud.visionai.v1.AnalyzerDefinition.DebugOptions
	(*AnalyzerDefinition_OperatorOption)(nil),      // 12: google.cloud.visionai.v1.AnalyzerDefinition.OperatorOption
	nil, // 13: google.cloud.visionai.v1.AnalyzerDefinition.AttrsEntry
	nil, // 14: google.cloud.visionai.v1.AnalyzerDefinition.DebugOptions.EnvironmentVariablesEntry
}
var file_google_cloud_visionai_v1_lva_proto_depIdxs = []int32{
	8,  // 0: google.cloud.visionai.v1.OperatorDefinition.input_args:type_name -> google.cloud.visionai.v1.OperatorDefinition.ArgumentDefinition
	8,  // 1: google.cloud.visionai.v1.OperatorDefinition.output_args:type_name -> google.cloud.visionai.v1.OperatorDefinition.ArgumentDefinition
	9,  // 2: google.cloud.visionai.v1.OperatorDefinition.attributes:type_name -> google.cloud.visionai.v1.OperatorDefinition.AttributeDefinition
	3,  // 3: google.cloud.visionai.v1.OperatorDefinition.resources:type_name -> google.cloud.visionai.v1.ResourceSpecification
	10, // 4: google.cloud.visionai.v1.AnalyzerDefinition.inputs:type_name -> google.cloud.visionai.v1.AnalyzerDefinition.StreamInput
	13, // 5: google.cloud.visionai.v1.AnalyzerDefinition.attrs:type_name -> google.cloud.visionai.v1.AnalyzerDefinition.AttrsEntry
	11, // 6: google.cloud.visionai.v1.AnalyzerDefinition.debug_options:type_name -> google.cloud.visionai.v1.AnalyzerDefinition.DebugOptions
	12, // 7: google.cloud.visionai.v1.AnalyzerDefinition.operator_option:type_name -> google.cloud.visionai.v1.AnalyzerDefinition.OperatorOption
	5,  // 8: google.cloud.visionai.v1.AnalysisDefinition.analyzers:type_name -> google.cloud.visionai.v1.AnalyzerDefinition
	1,  // 9: google.cloud.visionai.v1.RunStatus.state:type_name -> google.cloud.visionai.v1.RunStatus.State
	4,  // 10: google.cloud.visionai.v1.OperatorDefinition.AttributeDefinition.default_value:type_name -> google.cloud.visionai.v1.AttributeValue
	14, // 11: google.cloud.visionai.v1.AnalyzerDefinition.DebugOptions.environment_variables:type_name -> google.cloud.visionai.v1.AnalyzerDefinition.DebugOptions.EnvironmentVariablesEntry
	4,  // 12: google.cloud.visionai.v1.AnalyzerDefinition.AttrsEntry.value:type_name -> google.cloud.visionai.v1.AttributeValue
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_visionai_v1_lva_proto_init() }
func file_google_cloud_visionai_v1_lva_proto_init() {
	if File_google_cloud_visionai_v1_lva_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visionai_v1_lva_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperatorDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceSpecification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalysisDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperatorDefinition_ArgumentDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperatorDefinition_AttributeDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerDefinition_StreamInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerDefinition_DebugOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzerDefinition_OperatorOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visionai_v1_lva_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*AttributeValue_I)(nil),
		(*AttributeValue_F)(nil),
		(*AttributeValue_B)(nil),
		(*AttributeValue_S)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visionai_v1_lva_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_visionai_v1_lva_proto_goTypes,
		DependencyIndexes: file_google_cloud_visionai_v1_lva_proto_depIdxs,
		EnumInfos:         file_google_cloud_visionai_v1_lva_proto_enumTypes,
		MessageInfos:      file_google_cloud_visionai_v1_lva_proto_msgTypes,
	}.Build()
	File_google_cloud_visionai_v1_lva_proto = out.File
	file_google_cloud_visionai_v1_lva_proto_rawDesc = nil
	file_google_cloud_visionai_v1_lva_proto_goTypes = nil
	file_google_cloud_visionai_v1_lva_proto_depIdxs = nil
}
