#pragma once
/*
 *  $Id: cwt.h 28777 2025-11-04 16:46:05Z yeti-dn $
 *  Copyright (C) 2003 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_CWT_H__
#define __GWY_CWT_H__

#include <glib.h>
#include <libgwyddion/field.h>

G_BEGIN_DECLS

typedef enum {
    GWY_CWT_2D_GAUSS,
    GWY_CWT_2D_HAT
} GwyCWT2DWaveletType;

const GwyEnum* gwy_cwt_2d_wavelet_type_get_enum(void)                       G_GNUC_CONST;
gdouble        gwy_cwt_wfunc_2d                (gdouble scale,
                                                gdouble mval,
                                                gint xres,
                                                GwyCWT2DWaveletType wtype);
void           gwy_field_cwt                   (GwyField *field,
                                                gdouble scale,
                                                GwyCWT2DWaveletType wtype);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
