/*
 * Copyright (c) 2002, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package nsk.jdi.BScenarios.singlethrd;

import nsk.share.*;
import nsk.share.jpda.*;
import nsk.share.jdi.*;

//    THIS TEST IS LINE NUMBER SENSITIVE

/**
 *  <code>tc05x001a</code> is deugee's part of the tc02x001.
 */
public class tc05x001a {

    public final static String brkpMethodName = "performTest";
    public final static int brkpLineNumber = 1;

    public final static int checkLastLine = 82;
    static Log log;

    public static void main (String argv[]) {
        ArgumentHandler argHandler = new ArgumentHandler(argv);
        log = new Log(System.err, argHandler);
        IOPipe pipe = argHandler.createDebugeeIOPipe(log);
        pipe.println(tc05x001.SGL_READY);

        tc05x001a obj = null;
        String instr;
        do {
            instr = pipe.readln();
            if (instr.equals(tc05x001.SGL_PERFORM)) {
                performTest();
            } else if (instr.equals(tc05x001.SGL_QUIT)) {
                log.display(instr);
                break;
            } else {
                log.complain("DEBUGEE> unexpected signal of debugger.");
                System.exit(Consts.TEST_FAILED + Consts.JCK_STATUS_BASE);
            }
        } while (true);
        log.display("completed succesfully.");
        System.exit(Consts.TEST_PASSED + Consts.JCK_STATUS_BASE);
    }

    public static void performTest() {
        log.display("performTest::creating tc05x001aClass1 object");
        tc05x001aClass1 obj = new tc05x001aClass1();
        log.display("performTest::invoking tc05x001aClass1.bar()");
        obj.bar();
    }
}

class tc05x001aClass1 {

    tc05x001aClass1() {
        tc05x001a.log.display("tc05x001aClass1::constructor is called");
    }

    public void bar() {
        tc05x001a.log.display("tc05x001aClass1.bar::" // checkLastLine
                                    + "method breakpoint should stop here");
    }
}
