%feature("docstring") OT::Poisson
R"RAW(Poisson distribution.

Parameters
----------
lambda : float, :math:`\lambda > 0`
    Mean and variance value.

    Default value is 1.0.

Notes
-----
Its probability distribution function is defined as:

.. math::

    \Prob{X = k} = \frac{\lambda^k}{k!}\;e^{-\lambda}, \,  k \in \Nset

It is evaluated using  Loader's algorithm, the *fast* and *accurate* method described in [loader2000]_,
with the further improvements mentioned in [dimitriadis2016]_, see :meth:`~openturns.DistFunc.dPoisson`.

Its first moments are:

.. math::
    :nowrap:

    \begin{eqnarray*}
        \Expect{X} & = & \lambda \\
        \Var{X} & = & \sqrt{\lambda}
    \end{eqnarray*}

The sampling is done using the rejection algorithm described in [devroye1986]_
and [stadlober1990]_, see :meth:`~openturns.DistFunc.rPoisson`.
    
Examples
--------
Create a distribution:

>>> import openturns as ot
>>> distribution = ot.Poisson(10.0)

Draw a sample:

>>> sample = distribution.getSample(5)
)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::Poisson::getLambda
"Accessor to the distribution's mean and variance value.

Returns
-------
lambda : float
    Distribution's mean and variance value."

// ---------------------------------------------------------------------

%feature("docstring") OT::Poisson::setLambda
"Accessor to the distribution's mean and variance value.

Parameters
----------
lambda : float
    Distribution's mean and variance value."
