# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ApiKey(_Model):
    """An API key used for authenticating with a configuration store endpoint.

    :ivar id: The key ID.
    :vartype id: str
    :ivar name: A name for the key describing its usage.
    :vartype name: str
    :ivar value: The value of the key that is used for authentication purposes.
    :vartype value: str
    :ivar connection_string: A connection string that can be used by supporting clients for
     authentication.
    :vartype connection_string: str
    :ivar last_modified: The last time any of the key's properties were modified.
    :vartype last_modified: ~datetime.datetime
    :ivar read_only: Whether this key can only be used for read operations.
    :vartype read_only: bool
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The key ID."""
    name: Optional[str] = rest_field(visibility=["read"])
    """A name for the key describing its usage."""
    value: Optional[str] = rest_field(visibility=["read"])
    """The value of the key that is used for authentication purposes."""
    connection_string: Optional[str] = rest_field(name="connectionString", visibility=["read"])
    """A connection string that can be used by supporting clients for authentication."""
    last_modified: Optional[datetime.datetime] = rest_field(name="lastModified", visibility=["read"], format="rfc3339")
    """The last time any of the key's properties were modified."""
    read_only: Optional[bool] = rest_field(name="readOnly", visibility=["read"])
    """Whether this key can only be used for read operations."""


class AzureFrontDoorProperties(_Model):
    """Azure Front Door settings.

    :ivar resource_id: Resource ID of an Azure Front Door profile.
    :vartype resource_id: str
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource ID of an Azure Front Door profile."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CheckNameAvailabilityParameters(_Model):
    """Parameters used for checking whether a resource name is available.

    :ivar name: The name to check for availability. Required.
    :vartype name: str
    :ivar type: The resource type to check for name availability. Required.
     "Microsoft.AppConfiguration/configurationStores"
    :vartype type: str or ~azure.mgmt.appconfiguration.models.ConfigurationResourceType
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name to check for availability. Required."""
    type: Union[str, "_models.ConfigurationResourceType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource type to check for name availability. Required.
     \"Microsoft.AppConfiguration/configurationStores\""""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.ConfigurationResourceType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfigurationStore(TrackedResource):
    """The configuration store along with all resource properties. The Configuration Store will have
    all information to begin utilizing it.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The properties of a configuration store.
    :vartype properties: ~azure.mgmt.appconfiguration.models.ConfigurationStoreProperties
    :ivar identity: The managed identity information, if configured.
    :vartype identity: ~azure.mgmt.appconfiguration.models.ResourceIdentity
    :ivar sku: The sku of the configuration store. Required.
    :vartype sku: ~azure.mgmt.appconfiguration.models.Sku
    """

    properties: Optional["_models.ConfigurationStoreProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a configuration store."""
    identity: Optional["_models.ResourceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed identity information, if configured."""
    sku: "_models.Sku" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku of the configuration store. Required."""

    __flattened_items = [
        "provisioning_state",
        "creation_date",
        "endpoint",
        "encryption",
        "private_endpoint_connections",
        "public_network_access",
        "disable_local_auth",
        "soft_delete_retention_in_days",
        "default_key_value_revision_retention_period_in_seconds",
        "enable_purge_protection",
        "data_plane_proxy",
        "create_mode",
        "telemetry",
        "managed_on_behalf_of_configuration",
        "azure_front_door",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ConfigurationStoreProperties"] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ConfigurationStoreProperties(_Model):
    """The properties of a configuration store.

    :ivar provisioning_state: The provisioning state of the configuration store. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.appconfiguration.models.ProvisioningState
    :ivar creation_date: The creation date of configuration store.
    :vartype creation_date: ~datetime.datetime
    :ivar endpoint: The DNS endpoint where the configuration store API will be available.
    :vartype endpoint: str
    :ivar encryption: The encryption settings of the configuration store.
    :vartype encryption: ~azure.mgmt.appconfiguration.models.EncryptionProperties
    :ivar private_endpoint_connections: The list of private endpoint connections that are set up
     for this resource.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.appconfiguration.models.PrivateEndpointConnectionReference]
    :ivar public_network_access: Control permission for data plane traffic coming from public
     networks while private endpoint is enabled. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.appconfiguration.models.PublicNetworkAccess
    :ivar disable_local_auth: Disables all authentication methods other than AAD authentication.
    :vartype disable_local_auth: bool
    :ivar soft_delete_retention_in_days: The amount of time in days that the configuration store
     will be retained when it is soft deleted.
    :vartype soft_delete_retention_in_days: int
    :ivar default_key_value_revision_retention_period_in_seconds: The duration in seconds to retain
     new key value revisions. Defaults to 604800 (7 days) for Free SKU stores and 2592000 (30 days)
     for Standard SKU stores and Premium SKU stores.
    :vartype default_key_value_revision_retention_period_in_seconds: int
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this configuration store.
    :vartype enable_purge_protection: bool
    :ivar data_plane_proxy: Property specifying the configuration of data plane proxy for Azure
     Resource Manager (ARM).
    :vartype data_plane_proxy: ~azure.mgmt.appconfiguration.models.DataPlaneProxyProperties
    :ivar create_mode: Indicates whether the configuration store need to be recovered. Known values
     are: "Recover" and "Default".
    :vartype create_mode: str or ~azure.mgmt.appconfiguration.models.CreateMode
    :ivar telemetry: Property specifying the configuration of telemetry for this configuration
     store.
    :vartype telemetry: ~azure.mgmt.appconfiguration.models.TelemetryProperties
    :ivar managed_on_behalf_of_configuration: Managed On Behalf Of Configuration.
    :vartype managed_on_behalf_of_configuration:
     ~azure.mgmt.appconfiguration.models.ManagedOnBehalfOfConfiguration
    :ivar azure_front_door: Property specifying the configuration of Azure Front Door for this
     configuration store.
    :vartype azure_front_door: ~azure.mgmt.appconfiguration.models.AzureFrontDoorProperties
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the configuration store. Known values are: \"Creating\",
     \"Updating\", \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    creation_date: Optional[datetime.datetime] = rest_field(name="creationDate", visibility=["read"], format="rfc3339")
    """The creation date of configuration store."""
    endpoint: Optional[str] = rest_field(visibility=["read"])
    """The DNS endpoint where the configuration store API will be available."""
    encryption: Optional["_models.EncryptionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption settings of the configuration store."""
    private_endpoint_connections: Optional[list["_models.PrivateEndpointConnectionReference"]] = rest_field(
        name="privateEndpointConnections", visibility=["read"]
    )
    """The list of private endpoint connections that are set up for this resource."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Control permission for data plane traffic coming from public networks while private endpoint is
     enabled. Known values are: \"Enabled\" and \"Disabled\"."""
    disable_local_auth: Optional[bool] = rest_field(
        name="disableLocalAuth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Disables all authentication methods other than AAD authentication."""
    soft_delete_retention_in_days: Optional[int] = rest_field(
        name="softDeleteRetentionInDays", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time in days that the configuration store will be retained when it is soft
     deleted."""
    default_key_value_revision_retention_period_in_seconds: Optional[int] = rest_field(
        name="defaultKeyValueRevisionRetentionPeriodInSeconds",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """The duration in seconds to retain new key value revisions. Defaults to 604800 (7 days) for Free
     SKU stores and 2592000 (30 days) for Standard SKU stores and Premium SKU stores."""
    enable_purge_protection: Optional[bool] = rest_field(
        name="enablePurgeProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying whether protection against purge is enabled for this configuration store."""
    data_plane_proxy: Optional["_models.DataPlaneProxyProperties"] = rest_field(
        name="dataPlaneProxy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying the configuration of data plane proxy for Azure Resource Manager (ARM)."""
    create_mode: Optional[Union[str, "_models.CreateMode"]] = rest_field(name="createMode", visibility=["create"])
    """Indicates whether the configuration store need to be recovered. Known values are: \"Recover\"
     and \"Default\"."""
    telemetry: Optional["_models.TelemetryProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying the configuration of telemetry for this configuration store."""
    managed_on_behalf_of_configuration: Optional["_models.ManagedOnBehalfOfConfiguration"] = rest_field(
        name="managedOnBehalfOfConfiguration", visibility=["read"]
    )
    """Managed On Behalf Of Configuration."""
    azure_front_door: Optional["_models.AzureFrontDoorProperties"] = rest_field(
        name="azureFrontDoor", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying the configuration of Azure Front Door for this configuration store."""

    @overload
    def __init__(
        self,
        *,
        encryption: Optional["_models.EncryptionProperties"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        disable_local_auth: Optional[bool] = None,
        soft_delete_retention_in_days: Optional[int] = None,
        default_key_value_revision_retention_period_in_seconds: Optional[int] = None,
        enable_purge_protection: Optional[bool] = None,
        data_plane_proxy: Optional["_models.DataPlaneProxyProperties"] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        telemetry: Optional["_models.TelemetryProperties"] = None,
        azure_front_door: Optional["_models.AzureFrontDoorProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfigurationStorePropertiesUpdateParameters(_Model):  # pylint: disable=name-too-long
    """The properties for updating a configuration store.

    :ivar encryption: The encryption settings of the configuration store.
    :vartype encryption: ~azure.mgmt.appconfiguration.models.EncryptionProperties
    :ivar disable_local_auth: Disables all authentication methods other than AAD authentication.
    :vartype disable_local_auth: bool
    :ivar public_network_access: Control permission for data plane traffic coming from public
     networks while private endpoint is enabled. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.appconfiguration.models.PublicNetworkAccess
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this configuration store.
    :vartype enable_purge_protection: bool
    :ivar data_plane_proxy: Property specifying the configuration of data plane proxy for Azure
     Resource Manager (ARM).
    :vartype data_plane_proxy: ~azure.mgmt.appconfiguration.models.DataPlaneProxyProperties
    :ivar default_key_value_revision_retention_period_in_seconds: The duration in seconds to retain
     new key value revisions. Defaults to 604800 (7 days) for Free SKU stores and 2592000 (30 days)
     for Standard SKU stores and Premium SKU stores.
    :vartype default_key_value_revision_retention_period_in_seconds: int
    :ivar telemetry: Property specifying the configuration of telemetry to update for this
     configuration store.
    :vartype telemetry: ~azure.mgmt.appconfiguration.models.TelemetryProperties
    :ivar azure_front_door: Property specifying the configuration of Azure Front Door for this
     configuration store.
    :vartype azure_front_door: ~azure.mgmt.appconfiguration.models.AzureFrontDoorProperties
    """

    encryption: Optional["_models.EncryptionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The encryption settings of the configuration store."""
    disable_local_auth: Optional[bool] = rest_field(
        name="disableLocalAuth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Disables all authentication methods other than AAD authentication."""
    public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = rest_field(
        name="publicNetworkAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Control permission for data plane traffic coming from public networks while private endpoint is
     enabled. Known values are: \"Enabled\" and \"Disabled\"."""
    enable_purge_protection: Optional[bool] = rest_field(
        name="enablePurgeProtection", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying whether protection against purge is enabled for this configuration store."""
    data_plane_proxy: Optional["_models.DataPlaneProxyProperties"] = rest_field(
        name="dataPlaneProxy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying the configuration of data plane proxy for Azure Resource Manager (ARM)."""
    default_key_value_revision_retention_period_in_seconds: Optional[int] = rest_field(
        name="defaultKeyValueRevisionRetentionPeriodInSeconds",
        visibility=["read", "create", "update", "delete", "query"],
    )
    """The duration in seconds to retain new key value revisions. Defaults to 604800 (7 days) for Free
     SKU stores and 2592000 (30 days) for Standard SKU stores and Premium SKU stores."""
    telemetry: Optional["_models.TelemetryProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying the configuration of telemetry to update for this configuration store."""
    azure_front_door: Optional["_models.AzureFrontDoorProperties"] = rest_field(
        name="azureFrontDoor", visibility=["read", "create", "update", "delete", "query"]
    )
    """Property specifying the configuration of Azure Front Door for this configuration store."""

    @overload
    def __init__(
        self,
        *,
        encryption: Optional["_models.EncryptionProperties"] = None,
        disable_local_auth: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        enable_purge_protection: Optional[bool] = None,
        data_plane_proxy: Optional["_models.DataPlaneProxyProperties"] = None,
        default_key_value_revision_retention_period_in_seconds: Optional[int] = None,
        telemetry: Optional["_models.TelemetryProperties"] = None,
        azure_front_door: Optional["_models.AzureFrontDoorProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConfigurationStoreUpdateParameters(_Model):
    """The parameters for updating a configuration store.

    :ivar properties: The properties for updating a configuration store.
    :vartype properties:
     ~azure.mgmt.appconfiguration.models.ConfigurationStorePropertiesUpdateParameters
    :ivar identity: The managed identity information for the configuration store.
    :vartype identity: ~azure.mgmt.appconfiguration.models.ResourceIdentity
    :ivar sku: The SKU of the configuration store.
    :vartype sku: ~azure.mgmt.appconfiguration.models.Sku
    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    """

    properties: Optional["_models.ConfigurationStorePropertiesUpdateParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties for updating a configuration store."""
    identity: Optional["_models.ResourceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed identity information for the configuration store."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU of the configuration store."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ARM resource tags."""

    __flattened_items = [
        "encryption",
        "disable_local_auth",
        "public_network_access",
        "enable_purge_protection",
        "data_plane_proxy",
        "default_key_value_revision_retention_period_in_seconds",
        "telemetry",
        "azure_front_door",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ConfigurationStorePropertiesUpdateParameters"] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DataPlaneProxyProperties(_Model):
    """The data plane proxy settings for a configuration store.

    :ivar authentication_mode: The data plane proxy authentication mode. This property manages the
     authentication mode of request to the data plane resources. Known values are: "Local" and
     "Pass-through".
    :vartype authentication_mode: str or ~azure.mgmt.appconfiguration.models.AuthenticationMode
    :ivar private_link_delegation: The data plane proxy private link delegation. This property
     manages if a request from delegated ARM private link is allowed when the data plane resource
     requires private link. Known values are: "Enabled" and "Disabled".
    :vartype private_link_delegation: str or
     ~azure.mgmt.appconfiguration.models.PrivateLinkDelegation
    """

    authentication_mode: Optional[Union[str, "_models.AuthenticationMode"]] = rest_field(
        name="authenticationMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The data plane proxy authentication mode. This property manages the authentication mode of
     request to the data plane resources. Known values are: \"Local\" and \"Pass-through\"."""
    private_link_delegation: Optional[Union[str, "_models.PrivateLinkDelegation"]] = rest_field(
        name="privateLinkDelegation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The data plane proxy private link delegation. This property manages if a request from delegated
     ARM private link is allowed when the data plane resource requires private link. Known values
     are: \"Enabled\" and \"Disabled\"."""

    @overload
    def __init__(
        self,
        *,
        authentication_mode: Optional[Union[str, "_models.AuthenticationMode"]] = None,
        private_link_delegation: Optional[Union[str, "_models.PrivateLinkDelegation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    """


class DeletedConfigurationStore(ProxyResource):
    """Deleted configuration store information with extended details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    :ivar properties: Properties of the deleted configuration store.
    :vartype properties: ~azure.mgmt.appconfiguration.models.DeletedConfigurationStoreProperties
    """

    properties: Optional["_models.DeletedConfigurationStoreProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the deleted configuration store."""

    __flattened_items = [
        "configuration_store_id",
        "location",
        "deletion_date",
        "scheduled_purge_date",
        "tags",
        "purge_protection_enabled",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.DeletedConfigurationStoreProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class DeletedConfigurationStoreProperties(_Model):
    """Properties of the deleted configuration store.

    :ivar configuration_store_id: The resource id of the original configuration store.
    :vartype configuration_store_id: str
    :ivar location: The location of the original configuration store.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar tags: Tags of the original configuration store.
    :vartype tags: dict[str, str]
    :ivar purge_protection_enabled: Purge protection status of the original configuration store.
    :vartype purge_protection_enabled: bool
    """

    configuration_store_id: Optional[str] = rest_field(name="configurationStoreId", visibility=["read"])
    """The resource id of the original configuration store."""
    location: Optional[str] = rest_field(visibility=["read"])
    """The location of the original configuration store."""
    deletion_date: Optional[datetime.datetime] = rest_field(name="deletionDate", visibility=["read"], format="rfc3339")
    """The deleted date."""
    scheduled_purge_date: Optional[datetime.datetime] = rest_field(
        name="scheduledPurgeDate", visibility=["read"], format="rfc3339"
    )
    """The scheduled purged date."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read"])
    """Tags of the original configuration store."""
    purge_protection_enabled: Optional[bool] = rest_field(name="purgeProtectionEnabled", visibility=["read"])
    """Purge protection status of the original configuration store."""


class EncryptionProperties(_Model):
    """The encryption settings for a configuration store.

    :ivar key_vault_properties: Key vault properties.
    :vartype key_vault_properties: ~azure.mgmt.appconfiguration.models.KeyVaultProperties
    """

    key_vault_properties: Optional["_models.KeyVaultProperties"] = rest_field(
        name="keyVaultProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Key vault properties."""

    @overload
    def __init__(
        self,
        *,
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.appconfiguration.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.appconfiguration.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.appconfiguration.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyValue(ProxyResource):
    """The key-value resource along with all resource properties.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    :ivar properties: All key-value properties.
    :vartype properties: ~azure.mgmt.appconfiguration.models.KeyValueProperties
    """

    properties: Optional["_models.KeyValueProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """All key-value properties."""

    __flattened_items = ["key", "label", "value", "content_type", "e_tag", "last_modified", "locked", "tags"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.KeyValueProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class KeyValueFilter(_Model):
    """Enables filtering of key-values.

    :ivar key: Filters key-values by their key field. Required.
    :vartype key: str
    :ivar label: Filters key-values by their label field.
    :vartype label: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Filters key-values by their key field. Required."""
    label: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Filters key-values by their label field."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        label: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyValueProperties(_Model):
    """All key-value properties.

    :ivar key: The primary identifier of a key-value.
     The key is used in unison with the label to uniquely identify a key-value.
    :vartype key: str
    :ivar label: A value used to group key-values.
     The label is used in unison with the key to uniquely identify a key-value.
    :vartype label: str
    :ivar value: The value of the key-value.
    :vartype value: str
    :ivar content_type: The content type of the key-value's value.
     Providing a proper content-type can enable transformations of values when they are retrieved by
     applications.
    :vartype content_type: str
    :ivar e_tag: An ETag indicating the state of a key-value within a configuration store.
    :vartype e_tag: str
    :ivar last_modified: The last time a modifying operation was performed on the given key-value.
    :vartype last_modified: ~datetime.datetime
    :ivar locked: A value indicating whether the key-value is locked.
     A locked key-value may not be modified until it is unlocked.
    :vartype locked: bool
    :ivar tags: A dictionary of tags that can help identify what a key-value may be applicable for.
    :vartype tags: dict[str, str]
    """

    key: Optional[str] = rest_field(visibility=["read"])
    """The primary identifier of a key-value.
     The key is used in unison with the label to uniquely identify a key-value."""
    label: Optional[str] = rest_field(visibility=["read"])
    """A value used to group key-values.
     The label is used in unison with the key to uniquely identify a key-value."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value of the key-value."""
    content_type: Optional[str] = rest_field(
        name="contentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The content type of the key-value's value.
     Providing a proper content-type can enable transformations of values when they are retrieved by
     applications."""
    e_tag: Optional[str] = rest_field(name="eTag", visibility=["read"])
    """An ETag indicating the state of a key-value within a configuration store."""
    last_modified: Optional[datetime.datetime] = rest_field(name="lastModified", visibility=["read"], format="rfc3339")
    """The last time a modifying operation was performed on the given key-value."""
    locked: Optional[bool] = rest_field(visibility=["read"])
    """A value indicating whether the key-value is locked.
     A locked key-value may not be modified until it is unlocked."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A dictionary of tags that can help identify what a key-value may be applicable for."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        content_type: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyVaultProperties(_Model):
    """Settings concerning key vault encryption for a configuration store.

    :ivar key_identifier: The URI of the key vault key used to encrypt data.
    :vartype key_identifier: str
    :ivar identity_client_id: The client id of the identity which will be used to access key vault.
    :vartype identity_client_id: str
    """

    key_identifier: Optional[str] = rest_field(
        name="keyIdentifier", visibility=["read", "create", "update", "delete", "query"]
    )
    """The URI of the key vault key used to encrypt data."""
    identity_client_id: Optional[str] = rest_field(
        name="identityClientId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The client id of the identity which will be used to access key vault."""

    @overload
    def __init__(
        self,
        *,
        key_identifier: Optional[str] = None,
        identity_client_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogSpecification(_Model):
    """Specifications of the Log for Azure Monitoring.

    :ivar name: Name of the log.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the log.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of the log.
    :vartype blob_duration: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the log."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized friendly display name of the log."""
    blob_duration: Optional[str] = rest_field(
        name="blobDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Blob duration of the log."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedOnBehalfOfConfiguration(_Model):
    """Managed-On-Behalf-Of configuration properties. This configuration exists for the resources
    where a resource provider manages those resources on behalf of the resource owner.

    :ivar mobo_broker_resources: Managed-On-Behalf-Of broker resources.
    :vartype mobo_broker_resources: list[~azure.mgmt.appconfiguration.models.MoboBrokerResource]
    """

    mobo_broker_resources: Optional[list["_models.MoboBrokerResource"]] = rest_field(
        name="moboBrokerResources", visibility=["read"]
    )
    """Managed-On-Behalf-Of broker resources."""


class MetricDimension(_Model):
    """Specifications of the Dimension of metrics.

    :ivar name: Name of the dimension.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the dimension.
    :vartype display_name: str
    :ivar internal_name: Internal name of the dimension.
    :vartype internal_name: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the dimension."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized friendly display name of the dimension."""
    internal_name: Optional[str] = rest_field(
        name="internalName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Internal name of the dimension."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetricSpecification(_Model):
    """Specifications of the Metrics for Azure Monitoring.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the metric.
    :vartype display_name: str
    :ivar display_description: Localized friendly description of the metric.
    :vartype display_description: str
    :ivar unit: Unit that makes sense for the metric.
    :vartype unit: str
    :ivar aggregation_type: Only provide one value for this field. Valid values: Average, Minimum,
     Maximum, Total, Count.
    :vartype aggregation_type: str
    :ivar internal_metric_name: Internal metric name.
    :vartype internal_metric_name: str
    :ivar dimensions: Dimensions of the metric.
    :vartype dimensions: list[~azure.mgmt.appconfiguration.models.MetricDimension]
    :ivar fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
     duration where no metric is emitted/published.
    :vartype fill_gap_with_zero: bool
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the metric."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized friendly display name of the metric."""
    display_description: Optional[str] = rest_field(
        name="displayDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized friendly description of the metric."""
    unit: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit that makes sense for the metric."""
    aggregation_type: Optional[str] = rest_field(
        name="aggregationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count."""
    internal_metric_name: Optional[str] = rest_field(
        name="internalMetricName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Internal metric name."""
    dimensions: Optional[list["_models.MetricDimension"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Dimensions of the metric."""
    fill_gap_with_zero: Optional[bool] = rest_field(
        name="fillGapWithZero", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional. If set to true, then zero will be returned for time duration where no metric is
     emitted/published."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        internal_metric_name: Optional[str] = None,
        dimensions: Optional[list["_models.MetricDimension"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MoboBrokerResource(_Model):
    """Managed-On-Behalf-Of broker resource. This resource is created by the Resource Provider to
    manage some resources on behalf of the user.

    :ivar id: Resource identifier of a Managed-On-Behalf-Of broker resource.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource identifier of a Managed-On-Behalf-Of broker resource."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NameAvailabilityStatus(_Model):
    """The result of a request to check the availability of a resource name.

    :ivar name_available: The value indicating whether the resource name is available.
    :vartype name_available: bool
    :ivar message: If any, the error message that provides more detail for the reason that the name
     is not available.
    :vartype message: str
    :ivar reason: If any, the reason that the name is not available.
    :vartype reason: str
    """

    name_available: Optional[bool] = rest_field(name="nameAvailable", visibility=["read"])
    """The value indicating whether the resource name is available."""
    message: Optional[str] = rest_field(visibility=["read"])
    """If any, the error message that provides more detail for the reason that the name is not
     available."""
    reason: Optional[str] = rest_field(visibility=["read"])
    """If any, the reason that the name is not available."""


class OperationDefinition(_Model):
    """The definition of a configuration store operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The display information for the configuration store operation.
    :vartype display: ~azure.mgmt.appconfiguration.models.OperationDefinitionDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: ~azure.mgmt.appconfiguration.models.OperationProperties
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation name: {provider}/{resource}/{operation}."""
    is_data_action: Optional[bool] = rest_field(
        name="isDataAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the operation is a data action."""
    display: Optional["_models.OperationDefinitionDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The display information for the configuration store operation."""
    origin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Origin of the operation."""
    properties: Optional["_models.OperationProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Properties of the operation."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDefinitionDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.OperationProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDefinitionDisplay(_Model):
    """The display information for a configuration store operation.

    :ivar provider: The resource provider name: Microsoft App Configuration.".
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The resource provider name: Microsoft App Configuration.\"."""
    resource: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource on which the operation is performed."""
    operation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The operation that users can perform."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description for the operation."""

    @overload
    def __init__(
        self,
        *,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationProperties(_Model):
    """Extra Operation properties.

    :ivar service_specification: Service specifications of the operation.
    :vartype service_specification: ~azure.mgmt.appconfiguration.models.ServiceSpecification
    """

    service_specification: Optional["_models.ServiceSpecification"] = rest_field(
        name="serviceSpecification", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service specifications of the operation."""

    @overload
    def __init__(
        self,
        *,
        service_specification: Optional["_models.ServiceSpecification"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpoint(_Model):
    """Private endpoint which a connection belongs to.

    :ivar id: The resource Id for private endpoint.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource Id for private endpoint."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    :ivar properties: The properties of a private endpoint.
    :vartype properties: ~azure.mgmt.appconfiguration.models.PrivateEndpointConnectionProperties
    """

    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a private endpoint."""

    __flattened_items = ["provisioning_state", "private_endpoint", "private_link_service_connection_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateEndpointConnectionProperties(_Model):
    """Properties of a private endpoint connection.

    :ivar provisioning_state: The provisioning status of the private endpoint connection. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.appconfiguration.models.ProvisioningState
    :ivar private_endpoint: The resource of private endpoint.
    :vartype private_endpoint: ~azure.mgmt.appconfiguration.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.appconfiguration.models.PrivateLinkServiceConnectionState
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning status of the private endpoint connection. Known values are: \"Creating\",
     \"Updating\", \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    private_endpoint: Optional["_models.PrivateEndpoint"] = rest_field(
        name="privateEndpoint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource of private endpoint."""
    private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState" = rest_field(
        name="privateLinkServiceConnectionState", visibility=["read", "create", "update", "delete", "query"]
    )
    """A collection of information about the state of the connection between service consumer and
     provider. Required."""

    @overload
    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PrivateEndpointConnectionReference(_Model):
    """A reference to a related private endpoint connection.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: The properties of a private endpoint connection.
    :vartype properties: ~azure.mgmt.appconfiguration.models.PrivateEndpointConnectionProperties
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """The resource ID."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource."""
    properties: Optional["_models.PrivateEndpointConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of a private endpoint connection."""

    __flattened_items = ["provisioning_state", "private_endpoint", "private_link_service_connection_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateEndpointConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateLinkResource(ProxyResource):
    """A resource that supports private link capabilities.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    :ivar properties: Private link resource properties.
    :vartype properties: ~azure.mgmt.appconfiguration.models.PrivateLinkResourceProperties
    """

    properties: Optional["_models.PrivateLinkResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Private link resource properties."""

    __flattened_items = ["group_id", "required_members", "required_zone_names"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PrivateLinkResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class PrivateLinkResourceProperties(_Model):
    """Properties of a private link resource.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The list of required DNS zone names of the private link resource.
    :vartype required_zone_names: list[str]
    """

    group_id: Optional[str] = rest_field(name="groupId", visibility=["read"])
    """The private link resource group id."""
    required_members: Optional[list[str]] = rest_field(name="requiredMembers", visibility=["read"])
    """The private link resource required member names."""
    required_zone_names: Optional[list[str]] = rest_field(name="requiredZoneNames", visibility=["read"])
    """The list of required DNS zone names of the private link resource."""


class PrivateLinkServiceConnectionState(_Model):
    """The state of a private link service connection.

    :ivar status: The private link service connection status. Known values are: "Pending",
     "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.appconfiguration.models.ConnectionStatus
    :ivar description: The private link service connection description.
    :vartype description: str
    :ivar actions_required: Any action that is required beyond basic workflow (approve/ reject/
     disconnect). Known values are: "None" and "Recreate".
    :vartype actions_required: str or ~azure.mgmt.appconfiguration.models.ActionsRequired
    """

    status: Optional[Union[str, "_models.ConnectionStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The private link service connection status. Known values are: \"Pending\", \"Approved\",
     \"Rejected\", and \"Disconnected\"."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The private link service connection description."""
    actions_required: Optional[Union[str, "_models.ActionsRequired"]] = rest_field(
        name="actionsRequired", visibility=["read"]
    )
    """Any action that is required beyond basic workflow (approve/ reject/ disconnect). Known values
     are: \"None\" and \"Recreate\"."""

    @overload
    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ConnectionStatus"]] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RegenerateKeyParameters(_Model):
    """The parameters used to regenerate an API key.

    :ivar id: The id of the key to regenerate.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The id of the key to regenerate."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Replica(ProxyResource):
    """The replica resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    :ivar properties: All replica properties.
    :vartype properties: ~azure.mgmt.appconfiguration.models.ReplicaProperties
    :ivar location: The location of the replica.
    :vartype location: str
    """

    properties: Optional["_models.ReplicaProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """All replica properties."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The location of the replica."""

    __flattened_items = ["endpoint", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ReplicaProperties"] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ReplicaProperties(_Model):
    """All replica properties.

    :ivar endpoint: The URI of the replica where the replica API will be available.
    :vartype endpoint: str
    :ivar provisioning_state: The provisioning state of the replica. Known values are: "Creating",
     "Succeeded", "Deleting", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appconfiguration.models.ReplicaProvisioningState
    """

    endpoint: Optional[str] = rest_field(visibility=["read"])
    """The URI of the replica where the replica API will be available."""
    provisioning_state: Optional[Union[str, "_models.ReplicaProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the replica. Known values are: \"Creating\", \"Succeeded\",
     \"Deleting\", \"Failed\", and \"Canceled\"."""


class ResourceIdentity(_Model):
    """An identity that can be associated with a resource.

    :ivar type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes
     both an implicitly created identity and a set of user-assigned identities. The type 'None' will
     remove any identities. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.appconfiguration.models.IdentityType
    :ivar user_assigned_identities: The list of user-assigned identities associated with the
     resource. The user-assigned identity dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.appconfiguration.models.UserIdentity]
    :ivar principal_id: The principal id of the identity. This property will only be provided for a
     system-assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the resource's identity. This property will only
     be provided for a system-assigned identity.
    :vartype tenant_id: str
    """

    type: Optional[Union[str, "_models.IdentityType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an
     implicitly created identity and a set of user-assigned identities. The type 'None' will remove
     any identities. Known values are: \"None\", \"SystemAssigned\", \"UserAssigned\", and
     \"SystemAssigned, UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user-assigned identities associated with the resource. The user-assigned identity
     dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."""
    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal id of the identity. This property will only be provided for a system-assigned
     identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant id associated with the resource's identity. This property will only be provided for
     a system-assigned identity."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.IdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceSpecification(_Model):
    """Service specification payload.

    :ivar log_specifications: Specifications of the Log for Azure Monitoring.
    :vartype log_specifications: list[~azure.mgmt.appconfiguration.models.LogSpecification]
    :ivar metric_specifications: Specifications of the Metrics for Azure Monitoring.
    :vartype metric_specifications: list[~azure.mgmt.appconfiguration.models.MetricSpecification]
    """

    log_specifications: Optional[list["_models.LogSpecification"]] = rest_field(
        name="logSpecifications", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifications of the Log for Azure Monitoring."""
    metric_specifications: Optional[list["_models.MetricSpecification"]] = rest_field(
        name="metricSpecifications", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifications of the Metrics for Azure Monitoring."""

    @overload
    def __init__(
        self,
        *,
        log_specifications: Optional[list["_models.LogSpecification"]] = None,
        metric_specifications: Optional[list["_models.MetricSpecification"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Sku(_Model):
    """Describes a configuration store SKU.

    :ivar name: The SKU name of the configuration store. Required.
    :vartype name: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU name of the configuration store. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Snapshot(ProxyResource):
    """The snapshot resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appconfiguration.models.SystemData
    :ivar properties: All snapshot properties.
    :vartype properties: ~azure.mgmt.appconfiguration.models.SnapshotProperties
    """

    properties: Optional["_models.SnapshotProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """All snapshot properties."""

    __flattened_items = [
        "provisioning_state",
        "status",
        "filters",
        "composition_type",
        "created",
        "expires",
        "retention_period",
        "size",
        "items_count",
        "tags",
        "etag",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SnapshotProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SnapshotProperties(_Model):
    """All snapshot properties.

    :ivar provisioning_state: The provisioning state of the snapshot. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.appconfiguration.models.ProvisioningState
    :ivar status: The current status of the snapshot. Known values are: "Provisioning", "Ready",
     "Archived", and "Failed".
    :vartype status: str or ~azure.mgmt.appconfiguration.models.SnapshotStatus
    :ivar filters: A list of filters used to filter the key-values included in the snapshot.
     Required.
    :vartype filters: list[~azure.mgmt.appconfiguration.models.KeyValueFilter]
    :ivar composition_type: The composition type describes how the key-values within the snapshot
     are composed. The 'key' composition type ensures there are no two key-values containing the
     same key. The 'key_label' composition type ensures there are no two key-values containing the
     same key and label. Known values are: "Key" and "Key_Label".
    :vartype composition_type: str or ~azure.mgmt.appconfiguration.models.CompositionType
    :ivar created: The time that the snapshot was created.
    :vartype created: ~datetime.datetime
    :ivar expires: The time that the snapshot will expire.
    :vartype expires: ~datetime.datetime
    :ivar retention_period: The amount of time, in seconds, that a snapshot will remain in the
     archived state before expiring. This property is only writable during the creation of a
     snapshot. If not specified, the default lifetime of key-value revisions will be used.
    :vartype retention_period: int
    :ivar size: The size in bytes of the snapshot.
    :vartype size: int
    :ivar items_count: The amount of key-values in the snapshot.
    :vartype items_count: int
    :ivar tags: The tags of the snapshot. NOTE: These are data plane tags, not ARM tags.
    :vartype tags: dict[str, str]
    :ivar etag: A value representing the current state of the snapshot.
    :vartype etag: str
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the snapshot. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", and \"Canceled\"."""
    status: Optional[Union[str, "_models.SnapshotStatus"]] = rest_field(visibility=["read"])
    """The current status of the snapshot. Known values are: \"Provisioning\", \"Ready\",
     \"Archived\", and \"Failed\"."""
    filters: list["_models.KeyValueFilter"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of filters used to filter the key-values included in the snapshot. Required."""
    composition_type: Optional[Union[str, "_models.CompositionType"]] = rest_field(
        name="compositionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The composition type describes how the key-values within the snapshot are composed. The 'key'
     composition type ensures there are no two key-values containing the same key. The 'key_label'
     composition type ensures there are no two key-values containing the same key and label. Known
     values are: \"Key\" and \"Key_Label\"."""
    created: Optional[datetime.datetime] = rest_field(visibility=["read"], format="rfc3339")
    """The time that the snapshot was created."""
    expires: Optional[datetime.datetime] = rest_field(visibility=["read"], format="rfc3339")
    """The time that the snapshot will expire."""
    retention_period: Optional[int] = rest_field(name="retentionPeriod", visibility=["read", "create"])
    """The amount of time, in seconds, that a snapshot will remain in the archived state before
     expiring. This property is only writable during the creation of a snapshot. If not specified,
     the default lifetime of key-value revisions will be used."""
    size: Optional[int] = rest_field(visibility=["read"])
    """The size in bytes of the snapshot."""
    items_count: Optional[int] = rest_field(name="itemsCount", visibility=["read"])
    """The amount of key-values in the snapshot."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tags of the snapshot. NOTE: These are data plane tags, not ARM tags."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """A value representing the current state of the snapshot."""

    @overload
    def __init__(
        self,
        *,
        filters: list["_models.KeyValueFilter"],
        composition_type: Optional[Union[str, "_models.CompositionType"]] = None,
        retention_period: Optional[int] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.appconfiguration.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.appconfiguration.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TelemetryProperties(_Model):
    """Telemetry settings.

    :ivar resource_id: Resource ID of a resource enabling telemetry collection.
    :vartype resource_id: str
    """

    resource_id: Optional[str] = rest_field(
        name="resourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource ID of a resource enabling telemetry collection."""

    @overload
    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserIdentity(_Model):
    """A resource identity that is managed by the user of the service.

    :ivar principal_id: The principal ID of the user-assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the user-assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the user-assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the user-assigned identity."""
