#
# Default options for the gitlab CI test configurations
#
set( BUILD_SHARED_LIBS ON CACHE BOOL "" )

set( CMAKE_INSTALL_PREFIX "$ENV{PWD}/install-${VITE_CI_VERSION}" CACHE PATH "" )
set( CMAKE_VERBOSE_MAKEFILE ON CACHE BOOL "" )
set( CMAKE_EXPORT_COMPILE_COMMANDS ON CACHE BOOL "" )

if ( (DEFINED VITE_CI_BRANCH) AND ("${VITE_CI_BRANCH}" STREQUAL "master") )
  set( CMAKE_BUILD_TYPE RelWithDebInfo CACHE STRING "" FORCE )
  set( CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -Werror" CACHE STRING "" )
else()
  set( CMAKE_BUILD_TYPE Debug CACHE STRING "" FORCE )
  set( CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -O0 -g -Werror" CACHE STRING "" )
endif()

option(VITE_ENABLE_WARNING  "Enable warning messages"        ON)
option(VITE_ENABLE_COVERAGE "Enable flags for coverage test" ON)

# Parser includes
set(OTF2_DIR "$ENV{OTF2_DIR}" CACHE STRING "")
set(TAU_DIR "$ENV{TAU_DIR}" CACHE STRING "")

if ( ${VITE_CI_VERSION} STREQUAL "opengl" )
  set( USE_OPENGL      ON  CACHE BOOL "" )
  set( VITE_ENABLE_VBO OFF CACHE BOOL "" )

elseif( ${VITE_CI_VERSION} STREQUAL "vbo" )
  set( USE_OPENGL      ON CACHE BOOL "" )
  set( VITE_ENABLE_VBO ON CACHE BOOL "" )

elseif( ${VITE_CI_VERSION} STREQUAL "vulkan" )
  set( USE_OPENGL OFF CACHE BOOL "" )
  set( USE_VULKAN ON  CACHE BOOL "" )

elseif( ${VITE_CI_VERSION} STREQUAL "plugins" )
  set( USE_OPENGL      ON CACHE BOOL "" )
  set( VITE_ENABLE_VBO ON CACHE BOOL "" )

  set( VITE_PLUGINS_TRACEINFOS        ON CACHE BOOL "" )
  set( VITE_PLUGINS_MATRIX_VISUALIZER ON CACHE BOOL "" )
  set( VITE_PLUGINS_CRITICAL_PATH     ON CACHE BOOL "" )
  set( VITE_PLUGINS_DISTRIBUTIONS     ON CACHE BOOL "" )

elseif( ${VITE_CI_VERSION} STREQUAL "parsers" )
  set( USE_OPENGL      ON CACHE BOOL "" )
  set( VITE_ENABLE_VBO ON CACHE BOOL "" )

  set( VITE_ENABLE_MT_PARSERS ON CACHE BOOL "" )
  set( VITE_ENABLE_TAU        ON CACHE BOOL "" )
  set( VITE_ENABLE_OTF2       ON CACHE BOOL "" )
endif()
